package w83b.w83bOperacionesPaso.w83bMantenimientos.w83bUsuarios;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bBeans.W83bUsuariosBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaUsuariosExcelAction extends Q70ActionPasoOP{


	/**
	 * processOP.
	 *
	 * @param contexto a
	 * @param errores a
	 * @param mapping a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @throws Exception e
	 */	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}
	
	/**
	 * processForward.
	 *
	 * @param contexto a
	 * @param errors a
	 * @param mapping a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @return ActionForward
	 * @throws Exception e
	 */	
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListadoUsuarios.xls";
		InputStream inputStream = W83bTablaUsuariosExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream); // Creacin del libro
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List listaUsuarios = (ArrayList)contexto.get("w83bListaUsuarios");
        W83bUsuariosBean usuarioBean = (W83bUsuariosBean)contexto.get("w83bUsuariosTempBean");               
        
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);               

        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);               
        
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);               
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));               
        HashMap mapaUsuario=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);               
        
        HSSFRow row = sheet.createRow((short)1); // Creacin de la fila 1               
        HSSFCell cell = row.createCell((short)3);               
        row = sheet.getRow((short)4);               
        cell = row.getCell((short)2);               
        
        StringBuffer tituloImagenEs = (StringBuffer)mapaUsuario.get("tituloDepEs");               
        StringBuffer tituloImagenEu =  (StringBuffer)mapaUsuario.get("tituloDepEu");               
        cell.setCellValue(tituloImagenEu.toString());               
        
        cell = row.getCell((short)6);               
        cell.setCellValue(tituloImagenEs.toString());               
        
        tituloImagenEs = (StringBuffer)mapaUsuario.get("tituloDelelegacionEs");               
        tituloImagenEu = (StringBuffer)mapaUsuario.get("tituloDelelegacionEu");               

        row = sheet.getRow((short)6);               
        cell = row.getCell((short)2);               
        cell.setCellValue(tituloImagenEu.toString());               
        
        cell = row.getCell((short)6);               
        cell.setCellValue(tituloImagenEs.toString());               
        
        row = sheet.getRow((short)9);               
        cell = row.getCell((short)0);               
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.usuarios.listado").toUpperCase());               
        
        //MAPEO FORMULARIO
        row = sheet.getRow(Short.parseShort("12")); 
        cell = row.getCell(Short.parseShort("1"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.usuarios.dni"));
        cell = row.createCell(Short.parseShort("2"));
        if(!StringUtils.isEmpty(usuarioBean.getDni())){
	        sheet.addMergedRegion(new Region(W83bClsConstantes.DOCE,Short.parseShort("2"),W83bClsConstantes.DOCE,Short.parseShort("3")));//NOPMD
	        cell.setCellValue(usuarioBean.getDni().toUpperCase());
	        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        
        cell = row.getCell(Short.parseShort("6"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.usuarios.nombre"));
        
        cell = row.createCell(Short.parseShort("7"));
        if(!StringUtils.isEmpty(usuarioBean.getNombre())){
	        sheet.addMergedRegion(new Region(W83bClsConstantes.DOCE,Short.parseShort("7"),W83bClsConstantes.DOCE,Short.parseShort("9")));//NOPMD
	        cell.setCellValue(usuarioBean.getNombre().toUpperCase());
	        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        
        row = sheet.getRow(Short.parseShort("13")); 
        cell = row.getCell(Short.parseShort("1"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.usuarios.apellido1"));
        
        cell = row.createCell(Short.parseShort("2"));
        if(!StringUtils.isEmpty(usuarioBean.getApellido1())){
	        sheet.addMergedRegion(new Region(W83bClsConstantes.DOCE,Short.parseShort("2"),W83bClsConstantes.DOCE,Short.parseShort("5")));//NOPMD
	        cell.setCellValue(usuarioBean.getApellido1().toUpperCase());
	        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        cell = row.getCell(Short.parseShort("6"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.usuarios.apellido2"));
        
        cell = row.createCell(Short.parseShort("7"));
        if(StringUtils.isNotEmpty(usuarioBean.getApellido2())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("7"),W83bClsConstantes.TRECE,Short.parseShort("8")));//NOPMD
        	cell.setCellValue(usuarioBean.getApellido2().toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        }else{
        	cell.setCellValue("");
        }

        row = sheet.getRow(Short.parseShort("14")); 
        cell = row.getCell(Short.parseShort("1"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.usuarios.sindicato"));
        
        cell = row.createCell(Short.parseShort("2"));
        if(StringUtils.isNotEmpty(usuarioBean.getDescSindicato())){
	        	sheet.addMergedRegion(new Region(W83bClsConstantes.CATORCE,Short.parseShort("2"),W83bClsConstantes.CATORCE,Short.parseShort("5")));//NOPMD
	        	cell.setCellValue(usuarioBean.getDescSindicato().toUpperCase());
	        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.CATORCE,excel,wb));
	        }else{
	        	cell.setCellValue("");
	    }
		
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamnyo columna en chars)/(1/20)
        row = sheet.getRow(Short.parseShort("17")); // Creacin de la fila 1
        cell = row.getCell(Short.parseShort("0")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.usuarios.dni"));
        
        cell = row.getCell(Short.parseShort("1")); // Creacin de la columna 2 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.usuarios.nombreApellidos"));
        
        cell = row.getCell(Short.parseShort("5")); // Creacin de la columna 3 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.usuarios.sindicato"));
        
        cell = row.getCell(Short.parseShort("7")); // Creacin de la columna 4 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.usuarios.rol"));
        
        cell = row.getCell(Short.parseShort("9")); // Creacin de la columna 5 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.usuarios.fechaAlta"));
        
        cell = row.getCell(Short.parseShort("10")); // Creacin de la columna 6 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.usuarios.fechaBaja"));
        
        for(int i=0;i<listaUsuarios.size();i++){
        	row = sheet.createRow((short)W83bClsConstantes.DIECIOCHO+i); // Creacin de la fila 1//NOPMD
        	
        	cell = row.createCell(Short.parseShort("0")); 
        	W83bUsuariosBean usuBean = (W83bUsuariosBean) listaUsuarios.get(i);
        	
        	cell.setCellValue(usuBean.getDni());
        	cell.setCellStyle(this.estiloFila(i,excel));
        	
        	cell = row.createCell(Short.parseShort("1")); 
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+i,Short.parseShort("1"),W83bClsConstantes.DIECIOCHO+i,Short.parseShort("4")));//NOPMD
        	cell.setCellValue(usuBean.getNombre()+" "+usuBean.getApellido1()+" "+usuBean.getApellido2());
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("2")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("3")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("4")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	
        	cell = row.createCell(Short.parseShort("5"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+i,Short.parseShort("5"),W83bClsConstantes.DIECIOCHO+i,Short.parseShort("6")));//NOPMD
        	cell.setCellValue(usuBean.getSindicato());
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("6")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	        	
        	cell = row.createCell(Short.parseShort("7"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+i,Short.parseShort("7"),W83bClsConstantes.DIECIOCHO+i,Short.parseShort("8")));//NOPMD
        	cell.setCellValue(usuBean.getRol());
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("8")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	
        	cell = row.createCell(Short.parseShort("9"));
        	cell.setCellValue(usuBean.getFechaAlta());
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	
        	cell = row.createCell(Short.parseShort("10")); 
        	cell.setCellValue(usuBean.getFechaBaja());
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	
        }
        
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoUsuarios.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	/**
	 * Estilo fila.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
	
	
	/**
	 * Estilo fila numero centrado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaNumeroCentrado(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumeroCentrado;//NOPMD
		}else{
			return excel.styleTextoImparNumeroCentrado;			
		}
		
	}
	
	/**
	 * Estilo fila justificado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @param wb the wb
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaJustificado(int nFila, W83bUtilidadesExcel excel, HSSFWorkbook wb){
		return excel.styleFilaJustificado;
	}
}
